/* Cockos SWELL (Simple/Small Win32 Emulation Layer for Losers (who use OS X))
   Copyright (C) 2006-2007, Cockos, Inc.

    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
  

    SWELL provides _EXTREMELY BASIC_ win32 wrapping for OS X. It is far from complete, too.

  */


#ifndef _WDL_SWELL_H_
#define _WDL_SWELL_H_
#ifndef _WIN32

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>


#include <dlfcn.h>
#define FreeLibrary(x) dlclose(x)
#define GetProcAddress(h,v) dlsym(h,v)
#define LoadLibrary(x) dlopen(x,RTLD_LAZY)


#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#define RGB(r,g,b) (((r)<<16)|((g)<<8)|(b))
#define GetRValue(x) (((x)>>16)&0xff)
#define GetGValue(x) (((x)>>8)&0xff)
#define GetBValue(x) ((x)&0xff)

#define stricmp(x,y) strcasecmp(x,y)
#define strnicmp(x,y,z) strncasecmp(x,y,z)

#define DeleteFile(x) (!unlink(x))
#define MoveFile(x,y) (!rename(x,y))
#define GetCurrentDirectory(sz,buf) (!getcwd(buf,sz))
#define CreateDirectory(x,y) (!mkdir((x),0755))
#define wsprintf sprintf

#ifndef max
#define max(x,y) ((x)<(y)?(y):(x))
#define min(x,y) ((x)<(y)?(x):(y))
#endif


typedef unsigned int UINT;
typedef unsigned int WPARAM;
typedef long LPARAM;
typedef long LRESULT;


typedef struct 
{
  int x,y;
} POINT, *LPPOINT;

typedef struct 
{
  int left,top;
  int right, bottom;
} RECT, *LPRECT;


typedef struct {
  unsigned char fVirt;
  unsigned short key,cmd;
} ACCEL, *LPACCEL;


struct HWND__ {
  int bla;
};
typedef struct HWND__ *HWND;

typedef unsigned int DWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef signed char BOOL;
typedef void *WNDPROC;
typedef void *HANDLE;
typedef void *HMENU;
typedef void *HINSTANCE;
typedef struct {
  DWORD dwLowDateTime;
  DWORD dwHighDateTime;
} FILETIME;

typedef struct _GUID {
  unsigned long  Data1;
  unsigned short Data2;
  unsigned short Data3;
  unsigned char  Data4[8];
} GUID;

typedef struct {
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *LPMSG;
typedef void *HDC;
typedef void *HBRUSH;
typedef void *HPEN;
typedef void *HFONT;
typedef void *HICON;
typedef void *HBITMAP;
typedef void *HGDIOBJ;
typedef void *HCURSOR;


char *lstrcpyn(char *dest, const char *src, int l);
void Sleep(int ms);
DWORD GetTickCount();
#define timeGetTime() GetTickCount()
BOOL GetFileTime(void *fh, FILETIME *lpCreationTime, FILETIME *lpLastAccessTime, FILETIME *lpLastWriteTime);

BOOL WritePrivateProfileString(const char *appname, const char *keyname, const char *val, const char *fn);
DWORD GetPrivateProfileString(const char *appname, const char *keyname, const char *def, char *ret, int retsize, const char *fn);
int GetPrivateProfileInt(const char *appname, const char *keyname, int def, const char *fn);
BOOL GetPrivateProfileStruct(const char *appname, const char *keyname, void *buf, int bufsz, const char *fn);
BOOL WritePrivateProfileStruct(const char *appname, const char *keyname, const void *buf, int bufsz, const char *fn);

void *SWELL_CStringToCFString(const char *str);

BOOL PtInRect(RECT *r, POINT p);
BOOL ShellExecute(HWND hwndDlg, const char *action,  const char *content1, const char *content2, const char *content3, int blah);

/*
 ** swell-miscdlg.mm
 */
#define MB_OK 0
#define MB_OKCANCEL 1
#define MB_YESNOCANCEL 3
#define MB_YESNO 4
#define MB_RETRYCANCEL 5
#define IDCANCEL 1
#define IDOK 2
#define IDNO 3
#define IDYES 4
#define IDRETRY 5
#define MessageBox(a,b,c,d) SWELL_MessageBox(b,c,d)
int SWELL_MessageBox(const char *text, const char *caption, int type);

// extlist is something similar you'd pass getopenfilename, initialdir and initialfile are optional
char *BrowseForFiles(const char *text, const char *initialdir, 
					const char *initialfile, bool allowmul, const char *extlist); // free() the result of this

bool BrowseForSaveFile(const char *text, const char *initialdir, const char *initialfile, const char *extlist,
			char *fn, int fnsize);

bool BrowseForDirectory(const char *text, const char *initialdir, char *fn, int fnsize);

/*
 ** swell-wnd.mm
 */

// all of these treat HWND as NSView 
HWND GetDlgItem(HWND, int);
void ShowWindow(HWND, int);
void DestroyWindow(HWND hwnd); // can also take NSWindow *
void SetDlgItemText(HWND, int idx, const char *text);
void SetDlgItemInt(HWND, int idx, int val, int issigned);
int GetDlgItemInt(HWND, int idx, BOOL *translated, int issigned);
void GetDlgItemText(HWND, int idx, char *text, int textlen);
#define GetWindowText(hwnd,text,textlen) GetDlgItemText(hwnd,0,text,textlen)
#define SetWindowText(hwnd,text) SetDlgItemText(hwnd,0,text)
void CheckDlgButton(HWND hwnd, int idx, int check);
int IsDlgButtonChecked(HWND hwnd, int idx);
void EnableWindow(HWND hwnd, int enable);
void SetFocus(HWND hwnd); // these take NSWindow/NSView, and return NSView *
HWND GetFocus();
void SetForegroundWindow(HWND hwnd); // these take NSWindow/NSView, and return NSView *
HWND GetForegroundWindow();
#define GetActiveWindow() GetForegroundWindow()

HWND SetCapture(HWND hwnd);
HWND GetCapture();
void ReleaseCapture();
int IsChild(HWND hwndParent, HWND hwndChild);
HWND GetParent(HWND hwnd);
HWND SetParent(HWND hwnd, HWND newPar);

#define GW_HWNDFIRST        0
#define GW_HWNDLAST         1
#define GW_HWNDNEXT         2
#define GW_HWNDPREV         3
#define GW_OWNER            4
#define GW_CHILD            5
HWND GetWindow(HWND hwnd, int what);

void ClientToScreen(HWND hwnd, POINT *p);
void ScreenToClient(HWND hwnd, POINT *p);
void GetWindowRect(HWND hwnd, RECT *r);
void GetClientRect(HWND hwnd, RECT *r);
void SetWindowPos(HWND hwnd, HWND unused, int x, int y, int cx, int cy, int flags);
int GetWindowLong(HWND hwnd, int idx);
int SetWindowLong(HWND hwnd, int idx, int val);
#define GWL_USERDATA        (-21)
#define GWL_ID              (-12)
#define GWL_STYLE           (-16) // only supported for BS_ for now I think
#define GWL_WNDPROC         (-4)
#define DWL_DLGPROC         (-4) // map to GWL_WNDPROC for now

bool IsWindowVisible(HWND hwnd);
#define IsWindow(x) (!!(x)) // todo use isKindOf

void SetTimer(HWND hwnd, int timerid, int rate, unsigned long *notUsed);
void KillTimer(HWND hwnd, int timerid);

int SWELL_CB_AddString(HWND hwnd, int idx, const char *str);
void SWELL_CB_SetCurSel(HWND hwnd, int idx, int sel);
int SWELL_CB_GetCurSel(HWND hwnd, int idx);
int SWELL_CB_GetNumItems(HWND hwnd, int idx);
void SWELL_CB_SetItemData(HWND hwnd, int idx, int item, int data); // these two only work for the combo list version for now
int SWELL_CB_GetItemData(HWND hwnd, int idx, int item);
void SWELL_CB_Empty(HWND hwnd, int idx);
int SWELL_CB_InsertString(HWND hwnd, int idx, int pos, const char *str);
int SWELL_CB_GetItemText(HWND hwnd, int idx, int item, char *buf, int bufsz);
void SWELL_CB_DeleteString(HWND hwnd, int idx, int wh);

void SWELL_TB_SetPos(HWND hwnd, int idx, int pos);
void SWELL_TB_SetRange(HWND hwnd, int idx, int low, int hi);
int SWELL_TB_GetPos(HWND hwnd, int idx);
void SWELL_TB_SetTic(HWND hwnd, int idx, int pos);


// even more compatibility, yall
#define CB_ADDSTRING                0x0143
#define CB_DELETESTRING             0x0144
#define CB_GETCOUNT                 0x0146
#define CB_GETCURSEL                0x0147
#define CB_GETLBTEXT                0x0148
#define CB_INSERTSTRING             0x014A
#define CB_RESETCONTENT             0x014B
#define CB_SETCURSEL                0x014E
#define CB_GETITEMDATA              0x0150
#define CB_SETITEMDATA              0x0151
#define CB_INITSTORAGE              0x0161

#define LB_ADDSTRING            0x0180
#define LB_INSERTSTRING         0x0181
#define LB_DELETESTRING         0x0182
#define LB_RESETCONTENT         0x0184
#define LB_SETSEL               0x0185
#define LB_SETCURSEL            0x0186
#define LB_GETSEL               0x0187
#define LB_GETCURSEL            0x0188
#define LB_GETCOUNT             0x018B
#define LB_GETSELCOUNT          0x0190
#define LB_GETITEMDATA          0x0199
#define LB_SETITEMDATA          0x019A


#define TBM_GETPOS              (WM_USER)
#define TBM_SETTIC              (WM_USER+4)
#define TBM_SETPOS              (WM_USER+5)
#define TBM_SETRANGE            (WM_USER+6)
#define TBM_SETSEL              (WM_USER+10)

#define PBM_SETRANGE            (WM_USER+1)
#define PBM_SETPOS              (WM_USER+2)
#define PBM_DELTAPOS            (WM_USER+3)

#define BM_GETIMAGE        0x00F6
#define BM_SETIMAGE        0x00F7
#define IMAGE_BITMAP 0
#define IMAGE_ICON 1

typedef struct
{
  HWND  hwndFrom;
  UINT  idFrom;
  UINT  code;
}  NMHDR, *LPNMHDR;
#define NM_FIRST                (0U-  0U)       // generic to all controls
#define NM_LAST                 (0U- 99U)
#define NM_CLICK                (NM_FIRST-2)    // uses NMCLICK struct
#define NM_DBLCLK               (NM_FIRST-3)
#define NM_RCLICK               (NM_FIRST-5)    // uses NMCLICK struct

typedef struct {
  NMHDR   hdr;
  DWORD   dwItemSpec;
  DWORD   dwItemData;
  POINT   pt;
  DWORD   dwHitInfo;
} NMMOUSE, *LPNMMOUSE;
typedef NMMOUSE NMCLICK;
typedef LPNMMOUSE LPNMCLICK;

typedef struct 
{ 
  int mask, fmt,cx; 
  char *pszText; 
  int cchTextMax, iSubItem;
} LVCOLUMN;
typedef struct 
{ 
  int mask, iItem, iSubItem, state, stateMask; 
  char *pszText; 
  int cchTextMax, iImage, lParam;
} LVITEM;


void ListView_SetExtendedListViewStyleEx(HWND h, int flag, int mask);
void ListView_InsertColumn(HWND h, int pos, const LVCOLUMN *lvc);
int ListView_InsertItem(HWND h, const LVITEM *item);
void ListView_SetItemText(HWND h, int ipos, int cpos, const char *txt);
bool ListView_SetItem(HWND h, LVITEM *item);
int ListView_GetNextItem(HWND h, int istart, int flags);
bool ListView_GetItem(HWND h, LVITEM *item);
int ListView_GetItemState(HWND h, int ipos, int mask);
void ListView_DeleteItem(HWND h, int ipos);
void ListView_DeleteAllItems(HWND h);
int ListView_GetSelectedCount(HWND h);
int ListView_GetItemCount(HWND h);
int ListView_GetSelectionMark(HWND h);
void ListView_SetColumnWidth(HWND h, int colpos, int wid);
bool ListView_SetItemState(HWND h, int item, int state, int statemask);
void ListView_RedrawItems(HWND h, int startitem, int enditem);
void ListView_SetItemCount(HWND h, int cnt);
void ListView_EnsureVisible(HWND h, int i, BOOL pok);
bool ListView_GetSubItemRect(HWND h, int item, int subitem, int code, RECT *r);

typedef void *HIMAGELIST;
#define ImageList_Create(x,y,a,b,c) ImageList_CreateEx();
HIMAGELIST ImageList_CreateEx();
void ImageList_ReplaceIcon(HIMAGELIST list, int offset, HICON image);

#define LVSIL_STATE 1
void ListView_SetImageList(HWND h, HIMAGELIST imagelist, int which); 

#define LVIR_BOUNDS             0
#define LVIR_ICON               1
#define LVIR_LABEL              2
#define LVIR_SELECTBOUNDS       3

typedef struct
{
  POINT pt;
  UINT flags;
  int iItem;
  int iSubItem;    // this is was NOT in win95.  valid only for LVM_SUBITEMHITTEST
} LVHITTESTINFO, *LPLVHITTESTINFO;
int ListView_HitTest(HWND h, LVHITTESTINFO *pinf);
#define LVHT_NOWHERE            0x0001
#define LVHT_ONITEMICON         0x0002
#define LVHT_ONITEMLABEL        0x0004
#define LVHT_ONITEMSTATEICON    0x0008
#define LVHT_ONITEM             (LVHT_ONITEMICON | LVHT_ONITEMLABEL | LVHT_ONITEMSTATEICON)

#define LVHT_ABOVE              0x0010
#define LVHT_BELOW              0x0020
#define LVHT_TORIGHT            0x0040
#define LVHT_TOLEFT             0x0080

#define LVCF_TEXT 1
#define LVCF_WIDTH 2
#define LVIF_TEXT 1
#define LVIF_PARAM 2
#define LVIF_STATE 4
#define LVIS_SELECTED 1
#define LVIS_FOCUSED 2
#define LVNI_FOCUSED 1
#define INDEXTOSTATEIMAGEMASK(x) ((x)<<16)



typedef struct
{
  NMHDR   hdr;
  int     iItem;
  int     iSubItem;
  UINT    uNewState;
  UINT    uOldState;
  UINT    uChanged;
  POINT   ptAction;
  LPARAM  lParam;
} NMLISTVIEW, *LPNMLISTVIEW;

typedef struct {
  NMHDR hdr;
  LVITEM item;
} NMLVDISPINFO, *LPNMLVDISPINFO;

#define LVN_FIRST               (0U-100U)       // listview
#define LVN_LAST                (0U-199U)
#define LVN_BEGINDRAG           (LVN_FIRST-9)
#define LVN_ITEMCHANGED         (LVN_FIRST-1)
#define LVN_ODFINDITEM          (LVN_FIRST-52)
#define LVN_GETDISPINFO         (LVN_FIRST-50)

// ignored for now
#define LVS_EX_FULLROWSELECT 0


//tab control

typedef struct TCITEM
{
    UINT mask;
    DWORD dwState;
    DWORD dwStateMask;
    char *pszText;
    int cchTextMax;
    int iImage;

    LPARAM lParam;
} TCITEM, *LPTCITEM;


#define TCIF_TEXT               0x0001
#define TCIF_IMAGE              0x0002
#define TCIF_PARAM              0x0008
//#define TCIF_STATE              0x0010

int TabCtrl_GetItemCount(HWND hwnd);
BOOL TabCtrl_DeleteItem(HWND hwnd, int idx);
int TabCtrl_InsertItem(HWND hwnd, int idx, TCITEM *item);
int TabCtrl_SetCurSel(HWND hwnd, int idx);
int TabCtrl_GetCurSel(HWND hwnd);

#define TCN_FIRST               (0U-550U)       // tab control
#define TCN_LAST                (0U-580U)
#define TCN_SELCHANGE           (TCN_FIRST - 1)



#define BS_AUTOCHECKBOX 1
#define BS_AUTORADIOBUTTON 2
#define BS_AUTO3STATE 4

#define BST_CHECKED 1
#define BST_UNCHECKED 0
#define BST_INDETERMINATE 2
#define SW_HIDE 0
#define SW_SHOWNA 1
#define SW_SHOW 2
#define SW_NORMAL 2
#define SW_SHOWNORMAL 2

#define SWP_NOMOVE 1
#define SWP_NOSIZE 2
#define SWP_NOZORDER 4
#define SWP_NOACTIVATE 8
#define HWND_TOP (HWND)0
#define HWND_TOPMOST (HWND)0
#define HWND_BOTTOM (HWND)0
#define HWND_NOTOPMOST (HWND)0

void *SWELL_ModalWindowStart(HWND hwnd);
bool SWELL_ModalWindowRun(void *ctx, int *ret); // returns false and puts retval in *ret when done
void SWELL_ModalWindowEnd(void *ctx);

void SWELL_CloseWindow(HWND hwnd);

/*
 ** swell-menu.mm
 */
HMENU CreatePopupMenu(const char *title=NULL);
void DestroyMenu(HMENU hMenu);
int AddMenuItem(HMENU hMenu, int pos, const char *name, int tagid);
HMENU SWELL_GetDefaultWindowMenu();
void SWELL_SetDefaultWindowMenu(HMENU);

// most of these are ignored, actually, but TPM_NONOTIFY and TPM_RETURNCMD are now used
#define TPM_LEFTBUTTON  0x0000L
#define TPM_RIGHTBUTTON 0x0002L
#define TPM_LEFTALIGN   0x0000L
#define TPM_CENTERALIGN 0x0004L
#define TPM_RIGHTALIGN  0x0008L
#define TPM_TOPALIGN        0x0000L
#define TPM_VCENTERALIGN    0x0010L
#define TPM_BOTTOMALIGN     0x0020L
#define TPM_HORIZONTAL      0x0000L     /* Horz alignment matters more */
#define TPM_VERTICAL        0x0040L     /* Vert alignment matters more */
#define TPM_NONOTIFY        0x0080L     /* Don't send any notification msgs */
#define TPM_RETURNCMD       0x0100L

int SWELL_TrackPopupMenu(HMENU hMenu, int flags, int xpos, int ypos, HWND hwnd);
#define TrackPopupMenu(menu, flags, xpos, ypos, resvd, parent, rect) SWELL_TrackPopupMenu(menu,flags,xpos,ypos,parent)
HMENU GetSubMenu(HMENU hMenu, int pos);
int GetMenuItemCount(HMENU hMenu);
int GetMenuItemID(HMENU hMenu, int pos);
bool SetMenuItemModifier(HMENU hMenu, int idx, int flag, void *ModNSS, unsigned int mask);
bool SetMenuItemText(HMENU hMenu, int idx, int flag, const char *text);
bool EnableMenuItem(HMENU hMenu, int idx, int en);
bool DeleteMenu(HMENU hMenu, int idx, int flag);
struct SWELL_MenuResourceIndex;
extern struct SWELL_MenuResourceIndex *SWELL_curmodule_menuresource_head;
HMENU SWELL_LoadMenu(struct SWELL_MenuResourceIndex *head, int resid);
#define LoadMenu(hinst,resid) SWELL_LoadMenu(SWELL_curmodule_menuresource_head,(resid))
void SWELL_SetMenuDestination(HMENU menu, HWND hwnd);
HMENU SWELL_DuplicateMenu(HMENU menu);  

BOOL SetMenu(HWND hwnd, HMENU menu);
HMENU GetMenu(HWND hwnd);

bool CheckMenuItem(HMENU hMenu, int idx, int chk);
typedef struct
{
  unsigned int cbSize, fMask, fType, fState, wID;
  HMENU hSubMenu;
  void *hbmpChecked,*hbmpUnchecked;
  DWORD dwItemData;
  char *dwTypeData;
  int cch;
} MENUITEMINFO;
void InsertMenuItem(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi);
BOOL GetMenuItemInfo(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi);
BOOL SetMenuItemInfo(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi);
#define MIIM_ID 1
#define MIIM_STATE 2
#define MIIM_TYPE 4
#define MIIM_SUBMENU 8
#define MIIM_DATA 16
#define MFT_STRING 0
#define MFT_SEPARATOR 1
#define MFT_BITMAP 2

#define MF_UNCHECKED 0
#define MF_ENABLED 0
#define MF_GRAYED 1
#define MF_DISABLED 1
#define MF_CHECKED 4

#define MFS_UNCHECKED 0
#define MFS_ENABLED 0
#define MFS_GRAYED 1
#define MFS_CHECKED 4

#define MF_BYCOMMAND 0
#define MF_BYPOSITION 0x100




/*
  ** misc dlg
  */
#define EN_CHANGE           0x0300
#define STN_CLICKED         0
#define STN_DBLCLK          1
#define WM_CREATE                       0x0001
#define WM_DESTROY                      0x0002
#define WM_MOVE                         0x0003
#define WM_SIZE                         0x0005
#define WM_PAINT                        0x000F
#define WM_CLOSE                        0x0010
#define WM_ERASEBKGND                   0x0014
#define WM_SETCURSOR                    0x0020
#define WM_GETMINMAXINFO                0x0024

typedef struct {
  POINT ptReserved, ptMaxSize, ptMaxPosition, ptMinTrackSize, ptMaxTrackSize;
} MINMAXINFO, *LPMINMAXINFO;


#define WM_NOTIFY                       0x004E

#define WM_CONTEXTMENU                  0x007B
#define WM_KEYFIRST                     0x0100
#define WM_KEYDOWN                      0x0100
#define WM_KEYUP                        0x0101
#define WM_CHAR                         0x0102
#define WM_DEADCHAR                     0x0103
#define WM_SYSKEYDOWN                   0x0104
#define WM_SYSKEYUP                     0x0105
#define WM_SYSCHAR                      0x0106
#define WM_SYSDEADCHAR                  0x0107
#define WM_KEYLAST                      0x0108
#define WM_INITDIALOG                   0x0110
#define WM_COMMAND                      0x0111
#define WM_TIMER                        0x0113
#define WM_INITMENUPOPUP                0x0117
#define WM_HSCROLL                      0x0114
#define WM_VSCROLL                      0x0115
#define WM_MOUSEFIRST                   0x0200
#define WM_MOUSEMOVE                    0x0200
#define WM_LBUTTONDOWN                  0x0201
#define WM_LBUTTONUP                    0x0202
#define WM_LBUTTONDBLCLK                0x0203
#define WM_RBUTTONDOWN                  0x0204
#define WM_RBUTTONUP                    0x0205
#define WM_RBUTTONDBLCLK                0x0206
#define WM_MBUTTONDOWN                  0x0207
#define WM_MBUTTONUP                    0x0208
#define WM_MBUTTONDBLCLK                0x0209
#define WM_MOUSEWHEEL                   0x020A
#define WM_MOUSELAST                    0x020A
#define WM_USER                         0x0400      
#define CBN_SELCHANGE       0
#define CBN_EDITCHANGE 1
#define CB_ERR (-1)
#define SB_THUMBTRACK       5
#define SB_ENDSCROLL        8

#define SIZE_MINIMIZED (-1)
#define SIZE_MAXIMIZED (-2)

#ifndef WINAPI
#define WINAPI
#endif
                                       
#ifndef CALLBACK
#define CALLBACK
#endif

#ifndef MAKEINTRESOURCE
#define MAKEINTRESOURCE(x) (x)         
#endif                


                                                                              
#ifndef LOWORD
#define MAKEWORD(a, b)      ((unsigned short)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))
#define MAKELONG(a, b)      ((long)(((unsigned short)(a)) | ((DWORD)((unsigned short)(b))) << 16))
#define MAKEWPARAM(l, h)      (WPARAM)MAKELONG(l, h)
#define MAKELPARAM(l, h)      (LPARAM)MAKELONG(l, h)
#define MAKELRESULT(l, h)     (LRESULT)MAKELONG(l, h)
#define LOWORD(l)           ((unsigned short)(l))
#define HIWORD(l)           ((unsigned short)(((unsigned long)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((unsigned short)(w) >> 8) & 0xFF))
#endif

#define GET_X_LPARAM(lp)                        ((int)(short)LOWORD(lp))
#define GET_Y_LPARAM(lp)                        ((int)(short)HIWORD(lp))


#define DialogBox(hinst, resid, par, dlgproc) SWELL_DialogBox(SWELL_curmodule_dialogresource_head,resid,par,dlgproc,0)
#define DialogBoxParam(hinst, resid, par, dlgproc, param) SWELL_DialogBox(SWELL_curmodule_dialogresource_head,resid,par,dlgproc,param)
#define CreateDialog(hinst,resid,par,dlgproc) SWELL_CreateDialog(SWELL_curmodule_dialogresource_head,resid,par,dlgproc,0)
#define CreateDialogParam(hinst,resid,par,dlgproc,param) SWELL_CreateDialog(SWELL_curmodule_dialogresource_head,resid,par,dlgproc,param)

typedef BOOL (*DLGPROC)(HWND, UINT, WPARAM, LPARAM);
int SWELL_DialogBox(struct SWELL_DialogResourceIndex *reshead, int resid, HWND parent,  DLGPROC dlgproc, LPARAM param);  
HWND SWELL_CreateDialog(struct SWELL_DialogResourceIndex *reshead, int resid, HWND parent, DLGPROC dlgproc, LPARAM param);
extern struct SWELL_DialogResourceIndex *SWELL_curmodule_dialogresource_head;


typedef HWND (*SWELL_ControlCreatorProc)(HWND parent, const char *cname, int idx, const char *classname, int style, int x, int y, int w, int h);                                           
void SWELL_RegisterCustomControlCreator(SWELL_ControlCreatorProc roc);
void SWELL_UnregisterCustomControlCreator(SWELL_ControlCreatorProc proc);

void EndDialog(HWND, int);            

                                       
#define SendDlgItemMessage(hwnd,idx,msg,wparam,lparam) SendMessage(GetDlgItem(hwnd,idx),msg,wparam,lparam)
int SendMessage(HWND, UINT, WPARAM, LPARAM);                                      


BOOL PostMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
void SWELL_PostMessage_ClearQ(HWND h);



// these should never be called directly!!! put SWELL_POSTMESSAGE_DELEGATE_IMPL in your nsapp delegate, and call SWELL_POSTMESSAGE_INIT at some point from there too
void SWELL_Internal_PostMessage_Init();
BOOL SWELL_Internal_PostMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
void SWELL_Internal_PMQ_ClearAllMessages(HWND hwnd);
void SWELL_Internal_PMQ_Run();

#define SWELL_POSTMESSAGE_DELEGATE_IMPL \
    -(bool)swellPostMessage:(HWND)dest msg:(int)message wp:(WPARAM)wParam lp:(LPARAM)lParam { \
        return SWELL_Internal_PostMessage(dest,message,wParam,lParam); \
      } \
    -(void)swellPostMessageClearQ:(HWND)dest { \
        SWELL_Internal_PMQ_ClearAllMessages(dest); \
     } \
    -(void)swellPostMessageTick:(id)sender { \
        SWELL_Internal_PMQ_Run(); \
     } 

#define SWELL_POSTMESSAGE_INIT SWELL_Internal_PostMessage_Init();

/*
 ** swell-kb.mm
 */
int MacKeyToWindowsKey(void *nsevent, int *flags);
WORD GetAsyncKeyState(int key);
void GetCursorPos(POINT *pt);

#define FVIRTKEY  1
#define FSHIFT    0x04
#define FCONTROL  0x08
#define FALT      0x10


#define VK_BACK           0x08
#define VK_TAB            0x09

#define VK_CLEAR          0x0C
#define VK_RETURN         0x0D

#define VK_SHIFT          0x10
#define VK_CONTROL        0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL        0x14

#define VK_ESCAPE         0x1B

#define VK_SPACE          0x20
#define VK_PRIOR          0x21
#define VK_NEXT           0x22
#define VK_END            0x23
#define VK_HOME           0x24
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28
#define VK_SELECT         0x29
#define VK_PRINT          0x2A
#define VK_INSERT         0x2D
#define VK_DELETE         0x2E
#define VK_HELP           0x2F

#define VK_NUMPAD0        0x60
#define VK_NUMPAD1        0x61
#define VK_NUMPAD2        0x62
#define VK_NUMPAD3        0x63
#define VK_NUMPAD4        0x64
#define VK_NUMPAD5        0x65
#define VK_NUMPAD6        0x66
#define VK_NUMPAD7        0x67
#define VK_NUMPAD8        0x68
#define VK_NUMPAD9        0x69
#define VK_MULTIPLY       0x6A
#define VK_ADD            0x6B
#define VK_SEPARATOR      0x6C
#define VK_SUBTRACT       0x6D
#define VK_DECIMAL        0x6E
#define VK_DIVIDE         0x6F
#define VK_F1             0x70
#define VK_F2             0x71
#define VK_F3             0x72
#define VK_F4             0x73
#define VK_F5             0x74
#define VK_F6             0x75
#define VK_F7             0x76
#define VK_F8             0x77
#define VK_F9             0x78
#define VK_F10            0x79
#define VK_F11            0x7A
#define VK_F12            0x7B

#define MK_LBUTTON        0x10000
#define MK_MBUTTON        0x10001
#define MK_RBUTTON        0x10002


#define IDC_UPARROW -1004
#define IDC_NO -1003
#define IDC_SIZEALL -1002
#define IDC_SIZENS -1001
#define IDC_SIZEWE -1000
#define IDC_ARROW -999
#define IDC_HAND 32649
HCURSOR SWELL_LoadCursor(int idx);
#define LoadCursor(a,x) SWELL_LoadCursor(x)
void SetCursor(HCURSOR curs);
HCURSOR GetCursor();
HCURSOR SWELL_GetLastSetCursor();

/*
 ** clipboard
 */
bool OpenClipboard(HWND hwndDlg);
void CloseClipboard();
HANDLE GetClipboardData(UINT type);

void EmptyClipboard();
void SetClipboardData(UINT type, HANDLE h);
UINT RegisterClipboardFormat(const char *desc);
UINT EnumClipboardFormats(UINT lastfmt);

// these are only currently used by the clipboard system
#define GlobalAlloc(flags, size) SWELL_GlobalAlloc(size)
HANDLE SWELL_GlobalAlloc(int sz);
void *GlobalLock(HANDLE h);
int GlobalSize(HANDLE h);
void GlobalUnlock(HANDLE h);
void GlobalFree(HANDLE h);


/*
 ** swell-gdi.mm
 */


void InvalidateRect(HWND hwnd, RECT *r, int eraseBk);
void UpdateWindow(HWND hwnd);
HWND WindowFromPoint(POINT p);

typedef struct
{
    long lfHeight, lfWidth, lfEscapement,lfOrientation, lfWeight;
    char lfItalic, lfUnderline, lfStrikeOut, lfCharSet, lfOutPrecision, lfClipPrecision, 
         lfQuality, lfPitchAndFamily;
    char lfFaceName[32];
} LOGFONT;
typedef struct
{
  int tmAscent,tmInternalLeading;
  // todo: full struct
} TEXTMETRIC;

HDC WDL_GDP_CreateContext(void *);
HDC WDL_GDP_CreateMemContext(HDC hdc, int w, int h);
void WDL_GDP_DeleteContext(HDC);
HFONT CreateFontIndirect(LOGFONT *);
HFONT CreateFont(long lfHeight, long lfWidth, long lfEscapement, long lfOrientation, long lfWeight, char lfItalic, 
  char lfUnderline, char lfStrikeOut, char lfCharSet, char lfOutPrecision, char lfClipPrecision, 
         char lfQuality, char lfPitchAndFamily, const char *lfFaceName);

HPEN CreatePen(int attr, int wid, int col, float alpha=1.0f);
HBRUSH CreateSolidBrush(int col, float alpha=1.0f);
HGDIOBJ SelectObject(HDC ctx, HGDIOBJ pen);
HGDIOBJ GetStockObject(int wh);
void DeleteObject(HGDIOBJ);
void FillRect(HDC ctx, RECT *r, HBRUSH br);
void Rectangle(HDC ctx, int l, int t, int r, int b);
void Ellipse(HDC ctx, int l, int t, int r, int b);
void SWELL_Polygon(HDC ctx, POINT *pts, int npts);
void MoveToEx(HDC ctx, int x, int y, POINT *op);
void LineTo(HDC ctx, int x, int y);
void SetPixel(HDC ctx, int x, int y, int c);
void PolyBezierTo(HDC ctx, POINT *pts, int np);
int DrawText(HDC ctx, const char *buf, int len, RECT *r, int align);
void SetTextColor(HDC ctx, int col);
void SetBkColor(HDC ctx, int col);
void SetBkMode(HDC ctx, int col);

void RoundRect(HDC ctx, int x, int y, int x2, int y2, int xrnd, int yrnd);
void PolyPolyline(HDC ctx, POINT *pts, DWORD *cnts, int nseg);
BOOL GetTextMetrics(HDC ctx, TEXTMETRIC *tm);
void *GetNSImageFromHICON(HICON);
HICON LoadNamedImage(const char *name, bool alphaFromMask);
void DrawImageInRect(HDC ctx, HICON img, RECT *r);
void SWELL_PushClipRegion(HDC ctx);
void SWELL_SetClipRegion(HDC ctx, RECT *r);
void SWELL_PopClipRegion(HDC ctx);
void *SWELL_GetCtxFrameBuffer(HDC ctx);
void *SWELL_GetCtxGC(HDC ctx);
void SWELL_SyncCtxFrameBuffer(HDC ctx);
void SWELL_GetViewPort(RECT *r, RECT *sourcerect, bool wantWork);
void BitBlt(HDC hdcOut, int x, int y, int w, int h, HDC hdcIn, int xin, int yin, int mode);
void StretchBlt(HDC hdcOut, int x, int y, int w, int h, HDC hdcIn, int xin, int yin, int srcw, int srch, int mode);
#define DestroyIcon(x) DeleteObject(x)
int GetSysColor(int idx);


typedef struct {
  HDC         hdc;
  BOOL        fErase;
  RECT        rcPaint;
} PAINTSTRUCT;

HDC BeginPaint(HWND, PAINTSTRUCT *);
BOOL EndPaint(HWND, PAINTSTRUCT *);

long DefWindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);


#define COLOR_3DSHADOW 0
#define COLOR_3DHILIGHT 1
#define COLOR_3DFACE 2
#define COLOR_BTNTEXT 3
#define COLOR_WINDOW 4
#define COLOR_SCROLLBAR 5
#define COLOR_3DDKSHADOW 6
#define COLOR_BTNFACE 7
#define COLOR_INFOBK 8
#define COLOR_INFOTEXT 9

#define SRCCOPY 0
#define PS_SOLID 0
#define DT_CALCRECT 1
#define DT_VCENTER 2
#define DT_CENTER 4
#define DT_END_ELLIPSIS 8
#define DT_BOTTOM 16
#define DT_RIGHT 32
#define DT_SINGLELINE 64

#define DT_NOPREFIX 0
#define DT_TOP 0
#define DT_LEFT 0
#define FW_LIGHT 50
#define FW_NORMAL 100
#define FW_BOLD 400
#define OUT_DEFAULT_PRECIS 0
#define CLIP_DEFAULT_PRECIS 0
#define DEFAULT_QUALITY 0
#define DEFAULT_PITCH 0
#define DEFAULT_CHARSET 0
#define ANSI_CHARSET 0
#define Polygon(a,b,c) SWELL_Polygon(a,b,c)
#define TRANSPARENT 0
#define OPAQUE 1

#define NULL_PEN 1
#define NULL_BRUSH 2
#else

#define SWELL_CB_InsertString(hwnd, idx, pos, str) SendDlgItemMessage(hwnd,idx,CB_INSERTSTRING,(pos),(LPARAM)(str))
#define SWELL_CB_AddString(hwnd, idx, str) SendDlgItemMessage(hwnd,idx,CB_ADDSTRING,0,(LPARAM)(str))
#define SWELL_CB_SetCurSel(hwnd,idx,val) SendDlgItemMessage(hwnd,idx,CB_SETCURSEL,(WPARAM)(val),0)
#define SWELL_CB_GetNumItems(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_GETCOUNT,0,0)
#define SWELL_CB_GetCurSel(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_GETCURSEL,0,0)
#define SWELL_CB_SetItemData(hwnd,idx,item,val) SendDlgItemMessage(hwnd,idx,CB_SETITEMDATA,(item),(val))
#define SWELL_CB_GetItemData(hwnd,idx,item) SendDlgItemMessage(hwnd,idx,CB_GETITEMDATA,(item),0)
#define SWELL_CB_GetItemText(hwnd,idx,item,buf,bufsz) SendDlgItemMessage(hwnd,idx,CB_GETLBTEXT,(item),(LPARAM)(buf))
#define SWELL_CB_Empty(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_RESETCONTENT,0,0)
#define SWELL_CB_DeleteString(hwnd,idx,str) SendDlgItemMessage(hwnd,idx,CB_DELETESTRING,str,0)

#define SWELL_TB_SetPos(hwnd, idx, pos) SendDlgItemMessage(hwnd,idx, TBM_SETPOS,TRUE,(pos))
#define SWELL_TB_SetRange(hwnd, idx, low, hi) SendDlgItemMessage(hwnd,idx,TBM_SETRANGE,TRUE,(LPARAM)MAKELONG((low),(hi)))
#define SWELL_TB_GetPos(hwnd, idx) SendDlgItemMessage(hwnd,idx,TBM_GETPOS,0,0)
#define SWELL_TB_SetTic(hwnd, idx, pos) SendDlgItemMessage(hwnd,idx,TBM_SETTIC,0,(pos))

#endif//_WIN32


// stupid GDP compatibility layer, deprecated
#define WDL_GDP_CTX HDC
#define WDL_GDP_PEN HPEN
#define WDL_GDP_BRUSH HBRUSH
#define WDL_GDP_CreatePen(col, wid) (WDL_GDP_PEN)CreatePen(PS_SOLID,(wid),(col))
#define WDL_GDP_DeletePen(pen) DeleteObject((HGDIOBJ)(pen))
#define WDL_GDP_SetPen(ctx, pen) ((WDL_GDP_PEN)SelectObject(ctx,(HGDIOBJ)(pen)))
#define WDL_GDP_SetBrush(ctx, brush) ((WDL_GDP_BRUSH)SelectObject(ctx,(HGDIOBJ)(brush)))
#define WDL_GDP_CreateBrush(col) (WDL_GDP_BRUSH)CreateSolidBrush(col)
#define WDL_GDP_DeleteBrush(brush) DeleteObject((HGDIOBJ)(brush))
#define WDL_GDP_FillRectWithBrush(hdc,r,br) FillRect(hdc,r,(HBRUSH)(br))
#define WDL_GDP_Rectangle(hdc,l,t,r,b) Rectangle(hdc,l,t,r,b)
#define WDL_GDP_Polygon(hdc,pts,n) Polygon(hdc,pts,n)
#define WDL_GDP_MoveToEx(hdc,x,y,op) MoveToEx(hdc,x,y,op)
#define WDL_GDP_LineTo(hdc,x,y) LineTo(hdc,x,y)
#define WDL_GDP_PutPixel(hdc,x,y,c) SetPixel(hdc,x,y,c)
#define WDL_GDP_PolyBezierTo(hdc,p,np) PolyBezierTo(hdc,p,np)


#endif//_WDL_SWELL_H_
